/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.io.File;
import java.util.List;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.CompositeValidator;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.ivw.common.bean.HttpProxySettings;
import oracle.install.ivw.common.bean.MyOracleSupportSettings;
import oracle.install.ivw.common.resource.AutoUpdatesErrorCode;
import oracle.install.ivw.common.resource.AutoUpdatesManagerException;
import oracle.install.ivw.common.resource.PatchDownloadType;
import oracle.install.ivw.common.util.autoupdates.UpdateManager;
import oracle.install.library.util.GenericValidation;

public class AutoUpdatesOptionsValidator
implements CompositeValidator {
    StatusMessages<ValidationStatusMessage> messages;

    public StatusMessages<ValidationStatusMessage> getValidationStatusMessages() {
        return this.messages;
    }

    public void validate(FlowContext flowContext) throws ValidationException {
        if (this.messages == null) {
            this.messages = new StatusMessages();
        } else {
            this.messages.clear();
        }
        AutoUpdatesInstallSettings autoUpdatesBean = (AutoUpdatesInstallSettings)((Object)flowContext.getBean(AutoUpdatesInstallSettings.class));
        PatchDownloadType downloadType = autoUpdatesBean.getDownloadType();
        if (downloadType == PatchDownloadType.MYORACLESUPPORT_DOWNLOAD) {
            this.validateMyOracleSupportDetails(autoUpdatesBean.getMyoracleSupportDetails(), autoUpdatesBean.getHttpProxySettings());
            if (autoUpdatesBean.getHttpProxySettings() != null) {
                // empty if block
            }
            if (autoUpdatesBean.getMyoracleSupportDetails() != null) {
                String userName = autoUpdatesBean.getMyoracleSupportDetails().getUserId();
                String password = autoUpdatesBean.getMyoracleSupportDetails().getPassword();
                if (userName != null && userName.length() > 0 && password != null) {
                    this.validateForDownloadPrivileges(autoUpdatesBean.getMyoracleSupportDetails(), autoUpdatesBean.getHttpProxySettings());
                }
            }
        } else if (downloadType == PatchDownloadType.OFFLINE_UPDATES) {
            this.validatePatchDownloadLocation(autoUpdatesBean.getPatchDownloadLocation());
        }
    }

    public void validateMyOracleSupportDetails(MyOracleSupportSettings supportSettings, HttpProxySettings proxySettings) throws ValidationException {
        if (supportSettings != null) {
            if (supportSettings.getUserId() == null || supportSettings.getUserId().length() == 0) {
                this.messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)AutoUpdatesErrorCode.MYORACLESUPPORT_USERNAME_EMPTY, new Object[0]));
            } else if (!GenericValidation.validateEmailAddress(supportSettings.getUserId())) {
                this.messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)AutoUpdatesErrorCode.MYORACLESUPPORT_USERNAME_INVALID, new Object[0]));
            }
            if (supportSettings.getPassword() == null || supportSettings.getPassword().length() == 0) {
                this.messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)AutoUpdatesErrorCode.MYORACLESUPPORT_PASSWORD_EMPTY, new Object[0]));
            }
            if (supportSettings.getUserId() != null && supportSettings.getUserId().length() > 0 && supportSettings.getPassword() != null && supportSettings.getPassword().length() > 0) {
                try {
                    boolean connected = UpdateManager.getInstance().getConnection(supportSettings, proxySettings);
                    if (!connected) {
                        this.messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)AutoUpdatesErrorCode.MYORACLESUPPORT_CONNECTION_FAILED, new Object[0]));
                    }
                }
                catch (AutoUpdatesManagerException e) {
                    this.messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)AutoUpdatesErrorCode.MYORACLESUPPORT_CONNECTION_FAILED, new Object[]{e}));
                }
            }
        }
    }

    public void validateForDownloadPrivileges(MyOracleSupportSettings settings, HttpProxySettings proxyDet) {
        String useOldConnProperty = System.getProperty("USE_ARU_CONNECTION");
        if ((useOldConnProperty == null || useOldConnProperty.equalsIgnoreCase("false")) && !UpdateManager.getInstance().hasDownloadPrivileges(settings, proxyDet)) {
            this.messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)AutoUpdatesErrorCode.NO_DOWNLOAD_PRIVILEGES, new Object[0]));
        }
    }

    public void validatePatchDownloadLocation(String patchDownloadLocation) throws ValidationException {
        if (patchDownloadLocation == null || patchDownloadLocation.length() == 0) {
            this.messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)AutoUpdatesErrorCode.PATCHDOWNLOAD_LOCATION_EMPTY, new Object[0]));
        } else {
            List<String> xmlFileNames;
            String shiphomeLocation = "Shiphome";
            String oneoffsLocation = "OneOffs";
            String updatesLocation = "LatestUpdates";
            String metadataLocation = "metadata";
            String cpuLocation = "CPUs";
            File f1 = new File(patchDownloadLocation, updatesLocation);
            File f2 = new File(f1, oneoffsLocation);
            File f3 = new File(f1, shiphomeLocation);
            File f4 = new File(patchDownloadLocation, metadataLocation);
            File f5 = new File(f1, cpuLocation);
            if (!(f4.exists() && f1.exists() && (f2.exists() || f3.exists() || f5.exists()))) {
                this.messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)AutoUpdatesErrorCode.PATCHDOWNLOAD_LOCATION_INVALID, new Object[0]));
            }
            if (f5.exists() && (xmlFileNames = UpdateManager.getInstance().getAllCPURequiredXmls()) != null && xmlFileNames.size() > 0) {
                for (String xmlName : xmlFileNames) {
                    File f = new File(f1, xmlName);
                    if (f.exists()) continue;
                    this.messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)AutoUpdatesErrorCode.PATCHDOWNLOAD_LOCATION_INVALID, new Object[0]));
                    break;
                }
            }
        }
    }
}

